<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'perfil',
        'residencia_id',
        'personal_id',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        // No usar 'hashed' cast aquí porque los passwords existentes ya están hasheados
        // El cast 'hashed' solo se aplica al asignar, pero puede causar problemas al leer
    ];

    /**
     * Obtener la residencia del usuario
     */
    public function residencia(): BelongsTo
    {
        return $this->belongsTo(Residencia::class, 'residencia_id', 'id_residencia');
    }

    /**
     * Obtener el personal asociado al usuario
     */
    public function personal(): BelongsTo
    {
        return $this->belongsTo(Personal::class, 'personal_id', 'id_personal');
    }
}

